<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

$eventicity_args = get_query_var( 'eventicity_logo_args' );

// Site logo
$eventicity_logo_type   = isset( $eventicity_args['type'] ) ? $eventicity_args['type'] : '';
$eventicity_logo_image  = eventicity_get_logo_image( $eventicity_logo_type );
$eventicity_logo_text   = eventicity_is_on( eventicity_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$eventicity_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $eventicity_logo_image['logo'] ) || ! empty( $eventicity_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $eventicity_logo_image['logo'] ) ) {
			if ( empty( $eventicity_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($eventicity_logo_image['logo']) && (int) $eventicity_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$eventicity_attr = eventicity_getimagesize( $eventicity_logo_image['logo'] );
				echo '<img src="' . esc_url( $eventicity_logo_image['logo'] ) . '"'
						. ( ! empty( $eventicity_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $eventicity_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $eventicity_logo_text ) . '"'
						. ( ! empty( $eventicity_attr[3] ) ? ' ' . wp_kses_data( $eventicity_attr[3] ) : '' )
						. '>';
			}
		} else {
			eventicity_show_layout( eventicity_prepare_macros( $eventicity_logo_text ), '<span class="logo_text">', '</span>' );
			eventicity_show_layout( eventicity_prepare_macros( $eventicity_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
