<?php
/**
 * The template to display default site header
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

$eventicity_header_css   = '';
$eventicity_header_image = get_header_image();
$eventicity_header_video = eventicity_get_header_video();
if ( ! empty( $eventicity_header_image ) && eventicity_trx_addons_featured_image_override( is_singular() || eventicity_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$eventicity_header_image = eventicity_get_current_mode_image( $eventicity_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $eventicity_header_image ) || ! empty( $eventicity_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $eventicity_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $eventicity_header_image ) {
		echo ' ' . esc_attr( eventicity_add_inline_css_class( 'background-image: url(' . esc_url( $eventicity_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( eventicity_is_on( eventicity_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight eventicity-full-height';
	}
	$eventicity_header_scheme = eventicity_get_theme_option( 'header_scheme' );
	if ( ! empty( $eventicity_header_scheme ) && ! eventicity_is_inherit( $eventicity_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $eventicity_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $eventicity_header_video ) ) {
		get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( eventicity_is_on( eventicity_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
