<?php
$eventicity_slider_sc = eventicity_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $eventicity_slider_sc ) && strpos( $eventicity_slider_sc, '[' ) !== false && strpos( $eventicity_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( eventicity_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$eventicity_anchor_icon = eventicity_get_theme_option( 'front_page_title_anchor_icon' );
		$eventicity_anchor_text = eventicity_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $eventicity_anchor_icon ) || ! empty( $eventicity_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $eventicity_anchor_icon ) ? ' icon="' . esc_attr( $eventicity_anchor_icon ) . '"' : '' )
									. ( ! empty( $eventicity_anchor_text ) ? ' title="' . esc_attr( $eventicity_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $eventicity_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$eventicity_scheme = eventicity_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $eventicity_scheme ) && ! eventicity_is_inherit( $eventicity_scheme ) ) {
			echo ' scheme_' . esc_attr( $eventicity_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( eventicity_get_theme_option( 'front_page_title_paddings' ) );
		if ( eventicity_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$eventicity_css      = '';
		$eventicity_bg_image = eventicity_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $eventicity_bg_image ) ) {
			$eventicity_css .= 'background-image: url(' . esc_url( eventicity_get_attachment_url( $eventicity_bg_image ) ) . ');';
		}
		if ( ! empty( $eventicity_css ) ) {
			echo ' style="' . esc_attr( $eventicity_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$eventicity_anchor_icon = eventicity_get_theme_option( 'front_page_title_anchor_icon' );
		$eventicity_anchor_text = eventicity_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $eventicity_anchor_icon ) || ! empty( $eventicity_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $eventicity_anchor_icon ) ? ' icon="' . esc_attr( $eventicity_anchor_icon ) . '"' : '' )
									. ( ! empty( $eventicity_anchor_text ) ? ' title="' . esc_attr( $eventicity_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( eventicity_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' eventicity-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$eventicity_css      = '';
			$eventicity_bg_mask  = eventicity_get_theme_option( 'front_page_title_bg_mask' );
			$eventicity_bg_color_type = eventicity_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $eventicity_bg_color_type ) {
				$eventicity_bg_color = eventicity_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $eventicity_bg_color_type ) {
				$eventicity_bg_color = eventicity_get_scheme_color( 'bg_color', $eventicity_scheme );
			} else {
				$eventicity_bg_color = '';
			}
			if ( ! empty( $eventicity_bg_color ) && $eventicity_bg_mask > 0 ) {
				$eventicity_css .= 'background-color: ' . esc_attr(
					1 == $eventicity_bg_mask ? $eventicity_bg_color : eventicity_hex2rgba( $eventicity_bg_color, $eventicity_bg_mask )
				) . ';';
			}
			if ( ! empty( $eventicity_css ) ) {
				echo ' style="' . esc_attr( $eventicity_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$eventicity_caption = eventicity_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $eventicity_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $eventicity_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $eventicity_caption, 'eventicity_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$eventicity_description = eventicity_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $eventicity_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $eventicity_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $eventicity_description ), 'eventicity_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( eventicity_get_theme_option( 'front_page_title_button1_link' ) != '' || eventicity_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						eventicity_show_layout( eventicity_customizer_partial_refresh_front_page_title_button1_link() );
						eventicity_show_layout( eventicity_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
